<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Calendars</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Calendars</h1>
				<xsl:call-template name="calendars"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="calendars">
	<table>
		<tr>
			<th>id</th>
			<th>location</th>
			<th>hidden</th>
			<th>color</th>
			<th>accessLevel</th>
			<th>selected</th>
			<th>timezone</th>
			<th>url</th>
			<th>name</th>
			<th>displayName</th>
			<th>event</th>
		</tr>
		
		<xsl:for-each select="calendar">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@location"/></td>
				<td><xsl:value-of select="@hidden"/></td>
				<td><xsl:value-of select="@color"/></td>
				<td><xsl:value-of select="@accessLevel"/></td>
				<td><xsl:value-of select="@selected"/></td>
				<td><xsl:value-of select="@timezone"/></td>
				<td><xsl:value-of select="url"/></td>
				<td><xsl:value-of select="name"/></td>
				<td><xsl:value-of select="displayName"/></td>
				<td>
					<xsl:if test="count( event ) > 0">
						<xsl:call-template name="events"/>
					</xsl:if>
				</td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="events">
	<table>
		<tr>
			<th>id</th>
			<th>status</th>
			<th>eventLocation</th>
			<th>dtStart</th>
			<th>dtEnd</th>
			<th>duration</th>
			<th>timezone</th>
			<th>allDay</th>
			<th>visibility</th>
			<th>transparency</th>			
			<th>htmlUri</th>			
			<th>title</th>			
			<th>description</th>			
			<th>commentsUri</th>			
			<th>reoccurenceRule</th>			
			<th>reoccurenceDate</th>			
			<th>reoccurenceExceptionRule</th>			
			<th>reoccurenceExceptionDate</th>			
			<th>reoccurenceLastDate</th>
			<th>attendee</th>
			<th>reminder</th>
		</tr>
	
		<xsl:for-each select="event">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@status"/></td>
				<td><xsl:value-of select="@eventLocation"/></td>
				<td><xsl:value-of select="@dtStart"/></td>
				<td><xsl:value-of select="@dtEnd"/></td>
				<td><xsl:value-of select="@duration"/></td>
				<td><xsl:value-of select="@timezone"/></td>
				<td><xsl:value-of select="@allDay"/></td>
				<td><xsl:value-of select="@visibility"/></td>
				<td><xsl:value-of select="@transparency"/></td>
				<td><xsl:value-of select="htmlUri"/></td>
				<td><xsl:value-of select="title"/></td>
				<td><xsl:value-of select="description"/></td>
				<td><xsl:value-of select="commentsUri"/></td>
				<td><xsl:value-of select="reoccurenceRule"/></td>
				<td><xsl:value-of select="reoccurenceDate"/></td>
				<td><xsl:value-of select="reoccurenceExceptionRule"/></td>
				<td><xsl:value-of select="reoccurenceExceptionDate"/></td>
				<td><xsl:value-of select="reoccurenceLastDate"/></td>
				<td>
					<xsl:if test="count( attendee ) > 0">
						<xsl:call-template name="attendees"/>
					</xsl:if>
				</td>
				<td>
					<xsl:if test="count( reminder ) > 0">
						<xsl:call-template name="reminders"/>
					</xsl:if>
				</td>
				
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="attendees">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>email</th>
			<th>status</th>
			<th>relationship</th>
			<th>type</th>			
		</tr>
	
		<xsl:for-each select="attendee">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@email"/></td>
				<td><xsl:value-of select="@status"/></td>
				<td><xsl:value-of select="@relationship"/></td>
				<td><xsl:value-of select="@type"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

<xsl:template name="reminders">
	<table>
		<tr>
			<th>id</th>
			<th>minutes</th>
			<th>method</th>
		</tr>
	
		<xsl:for-each select="reminder">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@minutes"/></td>
				<td><xsl:value-of select="@method"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

